/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.ws.wsrr;

import filenet.vw.api.VWException;
import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWWSRRRegistry;
import filenet.vw.base.VWWSRRRegistryList;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.table.IVWSortItem;
import filenet.vw.toolkit.utils.table.VWQuickSort;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWToolTipTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.ws.wsrr.VWConfigWSRRCustomPropertiesTableModel;
import filenet.ws.api.wsrr.WSWSRRRegistry;
import filenet.ws.api.wsrr.WSWSRRWsdlDocument;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.text.Document;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public final class VWWSRRExplorerPanel
extends JPanel
implements ActionListener,
TreeSelectionListener,
TreeWillExpandListener,
ItemSelectable,
DocumentListener,
MouseListener {
    private Window m_parent = null;
    private VWSession m_session = null;
    private boolean m_bFirstTime = true;
    private VWWSRRRegistryList m_WSRRRegistryList = null;
    private JSplitPane m_mainPanel = null;
    private JScrollPane m_treeScrollPane = null;
    private JPanel m_blankPanel = new JPanel();
    private JScrollPane m_wsrrRegistryPane = null;
    private JPanel m_wsrrRegistryPanel = null;
    private JScrollPane m_wsdlDocDetailsPane = null;
    private JPanel m_wsdlDocDetailsPanel = null;
    private JScrollPane m_customPropertiesPane = null;
    private JPanel m_customPropertiesPanel = null;
    private JTabbedPane m_tabbedPanel = new JTabbedPane();
    private VWTable m_customPropertiesTable = null;
    private VWConfigWSRRCustomPropertiesTableModel m_tableModel = null;
    private JTextField m_wsrrRegistryNameUI = null;
    private JTextField m_registryURLUI = null;
    private JTextField m_wsrrQueryNameUI = null;
    private JCheckBox m_wsrrQueryCaseSensitiveUI = null;
    private JButton m_wsrrQueryExecuteBtn = null;
    private WSWSRRRegistry m_lastWSRRRegistryObject = null;
    private JTextField m_wsdlDocNameUI = null;
    private JTextArea m_wsdlDocNamespaceUI = null;
    private JTextArea m_wsdlDocLocationUI = null;
    private JTextArea m_wsdlURLUI = null;
    private JTextArea m_wsdlDocDescriptionUI = null;
    private JTextField m_wsdlDocOwnerUI = null;
    private JTextField m_wsdlDocVersionUI = null;
    private JTextField m_wsdlDocLastModifiedUI = null;
    private JTextField m_wsdlDocEncodingUI = null;
    private JTextField m_wsdlDocBsrURIUI = null;
    private WSWSRRWsdlDocument m_lastSelectedWsdlDocument = null;
    private WSWSRRWsdlDocument m_currentSelectedWsdlDocument = null;
    private DefaultMutableTreeNode m_rootNode = null;
    private JTree m_tree = null;
    private DefaultTreeModel m_treeModel = null;
    private DefaultMutableTreeNode[] m_registryTreeNodes = null;
    private JPopupMenu m_popup = null;
    private JMenuItem m_refreshMenuItem = null;
    private DefaultMutableTreeNode m_popupTreeNode = null;
    private Object m_popupUserObject = null;
    protected ItemListener m_selectListeners = null;
    private ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());

    public VWWSRRExplorerPanel(Frame parent, VWSession session) {
        super(new BorderLayout(10, 10));
        this.m_parent = parent;
        this.m_session = session;
        try {
            this.refetchRegistryList();
            this.setupLayout();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWWSRRExplorerPanel(Dialog parent, VWSession session) {
        super(new BorderLayout(10, 10));
        this.m_parent = parent;
        this.m_session = session;
        try {
            this.refetchRegistryList();
            this.setupLayout();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.m_bFirstTime) {
            this.m_bFirstTime = false;
            if (this.m_mainPanel != null) {
                this.m_mainPanel.setDividerLocation(0.5);
            }
        }
    }

    protected void initData(VWWSRRRegistry[] wsrrRegistries) {
        this.m_registryTreeNodes = null;
        if (this.m_rootNode == null) {
            this.m_rootNode = new DefaultMutableTreeNode(wsrrRegistries);
        } else {
            this.m_rootNode.removeAllChildren();
        }
        Vector<DefaultMutableTreeNode> registryNodes = new Vector<DefaultMutableTreeNode>();
        if (wsrrRegistries != null && wsrrRegistries.length > 0 && wsrrRegistries[0] != null) {
            try {
                DefaultMutableTreeNode registryNode = null;
                for (int i = 0; i < wsrrRegistries.length; ++i) {
                    String hostname = wsrrRegistries[i].getServerName();
                    String port = wsrrRegistries[i].getPort();
                    String username = wsrrRegistries[i].getUserName();
                    String password = wsrrRegistries[i].getPassword();
                    boolean bPublish = wsrrRegistries[i].getPublish();
                    WSWSRRRegistry aRegistry = null;
                    try {
                        if (port != null && port.compareTo("") == 0) {
                            aRegistry = WSWSRRRegistry.newWSRRRegistry(this.m_session, hostname);
                        } else {
                            int iPort = new Integer(port);
                            aRegistry = WSWSRRRegistry.newWSRRRegistry(this.m_session, hostname, iPort);
                        }
                    }
                    catch (VWException ex) {
                        aRegistry = null;
                        VWDebug.logException(ex, VWResource.s_failedToCreateWSRRObject.toString(hostname));
                    }
                    if (aRegistry == null) continue;
                    boolean bValidate = aRegistry.validateUser(username, password);
                    if (bValidate) {
                        aRegistry.setQueryUsernamePassword(username, password);
                    }
                    if (!aRegistry.hasQueryCredential()) continue;
                    if (i == 0) {
                        this.m_lastWSRRRegistryObject = aRegistry;
                    }
                    registryNode = new DefaultMutableTreeNode(aRegistry);
                    this.m_rootNode.add(registryNode);
                    registryNodes.add(registryNode);
                }
                if (registryNodes != null && registryNodes.size() > 0) {
                    this.m_registryTreeNodes = new DefaultMutableTreeNode[registryNodes.size()];
                    registryNodes.toArray(this.m_registryTreeNodes);
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
    }

    private void refresh() {
        if (this.m_session == null) {
            return;
        }
        this.refetchRegistryList();
        this.m_treeModel.nodeStructureChanged(this.m_rootNode);
    }

    private void refetchRegistryList() {
        try {
            this.m_WSRRRegistryList = new VWWSRRRegistryList(this.m_session);
            VWWSRRRegistry[] registries = this.m_WSRRRegistryList.getWSRRRegistries();
            this.initData(registries);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void setupLayout() {
        this.setVisible(false);
        this.m_mainPanel = new JSplitPane(1, false);
        this.m_treeScrollPane = this.initTreePanel();
        this.initInfoPane();
        if (this.compOrientation.isLeftToRight()) {
            this.m_mainPanel.setLeftComponent(this.m_treeScrollPane);
            this.m_mainPanel.setRightComponent(this.m_blankPanel);
        } else {
            this.m_mainPanel.setLeftComponent(this.m_blankPanel);
            this.m_mainPanel.setRightComponent(this.m_treeScrollPane);
        }
        this.m_mainPanel.applyComponentOrientation(this.compOrientation);
        this.add((Component)this.m_mainPanel, "Center");
    }

    private void initInfoPane() {
        try {
            Font aFont = this.getFont();
            this.m_tabbedPanel.setFont(new Font(aFont.getName(), 1, aFont.getSize()));
            this.initWSDLDocDetailsPanel();
            this.initCustomPropertiesPanel();
            this.m_tabbedPanel.add(VWResource.s_general, this.m_wsdlDocDetailsPane);
            this.m_tabbedPanel.add(VWResource.s_customProperties, this.m_customPropertiesPane);
            VWAccessibilityHelper.setAccessibility(this.m_wsdlDocDetailsPane, this.m_tabbedPanel, VWResource.s_general, VWResource.s_general);
            VWAccessibilityHelper.setAccessibility(this.m_customPropertiesPane, this.m_tabbedPanel, VWResource.s_customProperties, VWResource.s_customProperties);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void initCustomPropertiesPanel() {
        if (this.m_customPropertiesPane != null) {
            return;
        }
        this.m_customPropertiesPanel = new JPanel();
        this.m_customPropertiesPane = new JScrollPane(this.m_customPropertiesPanel);
        this.m_customPropertiesPanel.setLayout(new BorderLayout());
        VWToolbarBorder toolbarBorder = new VWToolbarBorder(VWResource.s_wsdlCustomProperties, 0);
        this.m_customPropertiesPanel.add((Component)toolbarBorder, "First");
        JPanel panel = toolbarBorder.getClientPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.setLayout(new BorderLayout());
        this.m_tableModel = new VWConfigWSRRCustomPropertiesTableModel(this.m_session, null);
        this.m_customPropertiesTable = new VWTable(this.m_tableModel);
        this.m_customPropertiesTable.setRowSelectionAllowed(true);
        this.m_customPropertiesTable.getSelectionModel().setSelectionMode(0);
        this.m_customPropertiesTable.setDefaultRenderer(String.class, new VWToolTipTableCellRenderer());
        panel.add((Component)new JScrollPane(this.m_customPropertiesTable), "Center");
    }

    private void updateCustomPropertiesPanel(WSWSRRWsdlDocument wsdlDocument) {
        this.initCustomPropertiesPanel();
        if (this.m_customPropertiesPane == null || wsdlDocument == null) {
            return;
        }
        String[] props = wsdlDocument.getUserDefinedProperties();
        this.m_tableModel.initRows(props);
        this.m_customPropertiesTable.setModel(this.m_tableModel);
    }

    private void initWSRRRegistryPanel() {
        if (this.m_wsrrRegistryPane != null) {
            return;
        }
        GridBagConstraints c = new GridBagConstraints();
        this.m_wsrrRegistryPanel = new JPanel();
        this.m_wsrrRegistryPane = new JScrollPane(this.m_wsrrRegistryPanel);
        this.m_wsrrRegistryPanel.setLayout(new BorderLayout());
        VWToolbarBorder toolbarBorder = new VWToolbarBorder(VWResource.s_wsrrRegistryDetails, 0);
        this.m_wsrrRegistryPanel.add((Component)toolbarBorder, "First");
        JPanel panel = toolbarBorder.getClientPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.setLayout(new GridBagLayout());
        JLabel serverNameLabel = new JLabel(VWResource.s_hostName);
        this.m_wsrrRegistryNameUI = new JTextField();
        this.m_wsrrRegistryNameUI.setEditable(false);
        this.m_wsrrRegistryNameUI.setBorder(null);
        JLabel registryURLLabel = new JLabel(VWResource.s_label.toString(VWResource.s_wsrrURL));
        this.m_registryURLUI = new JTextField();
        this.m_registryURLUI.setEditable(false);
        this.m_registryURLUI.setBorder(null);
        JLabel nameLabel = new JLabel(VWResource.s_label.toString(VWResource.s_name));
        this.m_wsrrQueryNameUI = new JTextField();
        this.m_wsrrQueryNameUI.getDocument().addDocumentListener(this);
        this.m_wsrrQueryNameUI.addActionListener(this);
        this.m_wsrrQueryCaseSensitiveUI = new JCheckBox(VWResource.s_caseSensitive);
        this.m_wsrrQueryCaseSensitiveUI.setSelected(false);
        this.m_wsrrQueryCaseSensitiveUI.addActionListener(this);
        this.m_wsrrQueryExecuteBtn = new JButton(VWResource.s_execute);
        this.m_wsrrQueryExecuteBtn.addActionListener(this);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.anchor = 23;
        c.fill = 2;
        panel.add((Component)serverNameLabel, c);
        c.gridy = 1;
        panel.add((Component)this.m_wsrrRegistryNameUI, c);
        c.gridy = 2;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)registryURLLabel, c);
        c.gridy = 3;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)this.m_registryURLUI, c);
        c.gridy = 4;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)nameLabel, c);
        c.gridy = 5;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)this.m_wsrrQueryNameUI, c);
        c.gridy = 6;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)this.m_wsrrQueryCaseSensitiveUI, c);
        c.gridy = 7;
        c.insets = new Insets(10, 0, 0, 0);
        c.anchor = 10;
        c.fill = 0;
        panel.add((Component)this.m_wsrrQueryExecuteBtn, c);
        this.setButtonStatus(this.m_wsrrQueryNameUI, this.m_wsrrQueryExecuteBtn);
    }

    private void showPopup(MouseEvent event) {
        TreePath path;
        Object obj;
        Object source = event.getSource();
        Point point = event.getPoint();
        if (source == this.m_tree && (obj = (path = this.m_tree.getPathForLocation(point.x, point.y)).getLastPathComponent()) != null && obj instanceof DefaultMutableTreeNode) {
            Object userObject = ((DefaultMutableTreeNode)obj).getUserObject();
            this.m_popupTreeNode = (DefaultMutableTreeNode)obj;
            this.m_popupUserObject = userObject;
            if (this.m_popupTreeNode != null && this.m_popupTreeNode.isRoot()) {
                this.createPopup(this.m_tree, event);
            }
        }
    }

    public void createPopup(Container container, MouseEvent evt) {
        Point point = evt.getPoint();
        if (this.m_popup == null) {
            this.m_popup = new JPopupMenu();
            if (this.m_refreshMenuItem == null) {
                this.m_refreshMenuItem = new JMenuItem(VWResource.s_refresh);
                this.m_refreshMenuItem.addActionListener(this);
            }
            this.m_popup.add(this.m_refreshMenuItem);
        }
        this.m_popup.show(container, point.x, point.y);
    }

    private void updateWSRRRegistryPanel(WSWSRRRegistry wsrrRegistry) {
        this.initWSRRRegistryPanel();
        if (this.m_wsrrRegistryPane == null || wsrrRegistry == null) {
            return;
        }
        if (this.m_wsrrRegistryNameUI != null) {
            this.m_wsrrRegistryNameUI.setText(wsrrRegistry.getRegisteryHostName());
        }
        if (this.m_registryURLUI != null) {
            this.m_registryURLUI.setText(wsrrRegistry.getRegistryURL());
        }
    }

    private void initWSDLDocDetailsPanel() {
        if (this.m_wsdlDocDetailsPane != null) {
            return;
        }
        GridBagConstraints c = new GridBagConstraints();
        this.m_wsdlDocDetailsPanel = new JPanel();
        this.m_wsdlDocDetailsPane = new JScrollPane(this.m_wsdlDocDetailsPanel);
        this.m_wsdlDocDetailsPanel.setLayout(new BorderLayout());
        VWToolbarBorder toolbarBorder = new VWToolbarBorder(VWResource.s_wsdlGeneralProperties, 0);
        this.m_wsdlDocDetailsPanel.add((Component)toolbarBorder, "First");
        JPanel panel = toolbarBorder.getClientPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.setLayout(new GridBagLayout());
        JLabel nameLabel = new JLabel(VWResource.s_label.toString(VWResource.s_name));
        this.m_wsdlDocNameUI = new JTextField();
        this.m_wsdlDocNameUI.setEditable(false);
        this.m_wsdlDocNameUI.setBorder(null);
        JLabel namespaceLabel = new JLabel(VWResource.s_label.toString(VWResource.s_namespace));
        this.m_wsdlDocNamespaceUI = new JTextArea();
        this.m_wsdlDocNamespaceUI.setEditable(false);
        this.m_wsdlDocNamespaceUI.setRows(3);
        this.m_wsdlDocNamespaceUI.setColumns(20);
        this.m_wsdlDocNamespaceUI.setLineWrap(true);
        this.m_wsdlDocNamespaceUI.setWrapStyleWord(true);
        this.m_wsdlDocNamespaceUI.setBackground(panel.getBackground());
        JLabel locationLabel = new JLabel(VWResource.s_label.toString(VWResource.s_location));
        this.m_wsdlDocLocationUI = new JTextArea();
        this.m_wsdlDocLocationUI.setEditable(false);
        this.m_wsdlDocLocationUI.setRows(3);
        this.m_wsdlDocLocationUI.setColumns(20);
        this.m_wsdlDocLocationUI.setLineWrap(true);
        this.m_wsdlDocLocationUI.setWrapStyleWord(true);
        this.m_wsdlDocLocationUI.setBackground(panel.getBackground());
        JLabel urlLabel = new JLabel(VWResource.s_label.toString(VWResource.s_wsdlURL));
        this.m_wsdlURLUI = new JTextArea();
        this.m_wsdlURLUI.setEditable(false);
        this.m_wsdlURLUI.setRows(3);
        this.m_wsdlURLUI.setColumns(20);
        this.m_wsdlURLUI.setLineWrap(true);
        this.m_wsdlURLUI.setWrapStyleWord(true);
        this.m_wsdlURLUI.setBackground(panel.getBackground());
        JLabel descriptionLabel = new JLabel(VWResource.s_label.toString(VWResource.s_description));
        this.m_wsdlDocDescriptionUI = new JTextArea();
        this.m_wsdlDocDescriptionUI.setEditable(false);
        this.m_wsdlDocDescriptionUI.setRows(3);
        this.m_wsdlDocDescriptionUI.setColumns(20);
        this.m_wsdlDocDescriptionUI.setLineWrap(true);
        this.m_wsdlDocDescriptionUI.setWrapStyleWord(true);
        this.m_wsdlDocDescriptionUI.setBackground(panel.getBackground());
        JLabel ownerLabel = new JLabel(VWResource.s_label.toString(VWResource.s_owner));
        this.m_wsdlDocOwnerUI = new JTextField();
        this.m_wsdlDocOwnerUI.setEditable(false);
        this.m_wsdlDocOwnerUI.setBorder(null);
        JLabel versionLabel = new JLabel(VWResource.s_label.toString(VWResource.s_version));
        this.m_wsdlDocVersionUI = new JTextField();
        this.m_wsdlDocVersionUI.setEditable(false);
        this.m_wsdlDocVersionUI.setBorder(null);
        JLabel lastModifiedLabel = new JLabel(VWResource.s_label.toString(VWResource.s_lastModified));
        this.m_wsdlDocLastModifiedUI = new JTextField();
        this.m_wsdlDocLastModifiedUI.setEditable(false);
        this.m_wsdlDocLastModifiedUI.setBorder(null);
        JLabel encodingLabel = new JLabel(VWResource.s_label.toString(VWResource.s_encoding));
        this.m_wsdlDocEncodingUI = new JTextField();
        this.m_wsdlDocEncodingUI.setEditable(false);
        this.m_wsdlDocEncodingUI.setBorder(null);
        JLabel bsrURILabel = new JLabel(VWResource.s_label.toString(VWResource.s_bsrURI));
        this.m_wsdlDocBsrURIUI = new JTextField();
        this.m_wsdlDocBsrURIUI.setEditable(false);
        this.m_wsdlDocBsrURIUI.setBorder(null);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.anchor = 23;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 2;
        panel.add((Component)nameLabel, c);
        ++c.gridy;
        panel.add((Component)this.m_wsdlDocNameUI, c);
        ++c.gridy;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)namespaceLabel, c);
        ++c.gridy;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)new JScrollPane(this.m_wsdlDocNamespaceUI), c);
        ++c.gridy;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)locationLabel, c);
        ++c.gridy;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)new JScrollPane(this.m_wsdlDocLocationUI), c);
        ++c.gridy;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)urlLabel, c);
        c.gridy = 7;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)new JScrollPane(this.m_wsdlURLUI), c);
        ++c.gridy;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)descriptionLabel, c);
        ++c.gridy;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)new JScrollPane(this.m_wsdlDocDescriptionUI), c);
        ++c.gridy;
        c.gridwidth = 1;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)ownerLabel, c);
        ++c.gridy;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)this.m_wsdlDocOwnerUI, c);
        ++c.gridy;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)versionLabel, c);
        c.gridy = 13;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)this.m_wsdlDocVersionUI, c);
        ++c.gridy;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)lastModifiedLabel, c);
        c.gridy = 15;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)this.m_wsdlDocLastModifiedUI, c);
        ++c.gridy;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)encodingLabel, c);
        c.gridy = 17;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)this.m_wsdlDocEncodingUI, c);
        ++c.gridy;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)bsrURILabel, c);
        ++c.gridy;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)this.m_wsdlDocBsrURIUI, c);
    }

    private void updateWSDLDocDetailsPanel(WSWSRRWsdlDocument wsdlDocument) {
        this.initWSDLDocDetailsPanel();
        if (this.m_wsdlDocDetailsPane == null || wsdlDocument == null) {
            return;
        }
        if (this.m_wsdlDocNameUI != null) {
            this.m_wsdlDocNameUI.setText(wsdlDocument.getName());
        }
        if (this.m_wsdlDocNamespaceUI != null) {
            this.m_wsdlDocNamespaceUI.setText(wsdlDocument.getNamespace());
        }
        if (this.m_wsdlDocLocationUI != null) {
            this.m_wsdlDocLocationUI.setText(wsdlDocument.getLocation());
        }
        if (this.m_wsdlURLUI != null) {
            this.m_wsdlURLUI.setText(wsdlDocument.getP8WSRRDocumentURI());
        }
        if (this.m_wsdlDocDescriptionUI != null) {
            this.m_wsdlDocDescriptionUI.setText(wsdlDocument.getDescription());
        }
        if (this.m_wsdlDocOwnerUI != null) {
            this.m_wsdlDocOwnerUI.setText(wsdlDocument.getOwner());
        }
        if (this.m_wsdlDocVersionUI != null) {
            this.m_wsdlDocVersionUI.setText(wsdlDocument.getVersion());
        }
        if (this.m_wsdlDocLastModifiedUI != null) {
            Date date;
            Long dateLong;
            String lastModified = wsdlDocument.getLastModified();
            this.m_wsdlDocLastModifiedUI.setText(null);
            if (lastModified != null && (dateLong = new Long(lastModified)) != null && (date = new Date(dateLong)) != null) {
                this.m_wsdlDocLastModifiedUI.setText(date.toString());
            }
        }
        if (this.m_wsdlDocEncodingUI != null) {
            this.m_wsdlDocEncodingUI.setText(wsdlDocument.getEncoding());
        }
        if (this.m_wsdlDocBsrURIUI != null) {
            this.m_wsdlDocBsrURIUI.setText(wsdlDocument.getBsrURI());
        }
        this.m_wsdlDocDetailsPane.updateUI();
    }

    public String getLastSelectedWSDLURL() {
        if (this.m_lastSelectedWsdlDocument != null) {
            return this.m_lastSelectedWsdlDocument.getP8WSRRDocumentURI();
        }
        return null;
    }

    public String getSelectedWSDLURL() {
        if (this.m_currentSelectedWsdlDocument != null) {
            return this.m_currentSelectedWsdlDocument.getP8WSRRDocumentURI();
        }
        return null;
    }

    private JScrollPane initTreePanel() {
        this.m_tree = new JTree(this.m_rootNode);
        this.m_tree.setCellRenderer(new TreeCellRenderer());
        ToolTipManager.sharedInstance().registerComponent(this.m_tree);
        this.m_tree.addTreeSelectionListener(this);
        this.m_tree.addTreeWillExpandListener(this);
        this.m_tree.addMouseListener(this);
        TreeModel treeModel = this.m_tree.getModel();
        if (treeModel != null && treeModel instanceof DefaultTreeModel) {
            this.m_treeModel = (DefaultTreeModel)treeModel;
        }
        VWAccessibilityHelper.setAccessibility(this.m_tree, this, VWResource.s_wsrrRegistryTree, VWResource.s_wsrrRegistryTree);
        return new JScrollPane(this.m_tree);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.m_wsrrQueryNameUI) {
            this.m_wsrrQueryExecuteBtn.doClick();
        } else if (source == this.m_wsrrQueryExecuteBtn) {
            this.executeWSRRQuery();
        } else if (source == this.m_refreshMenuItem && this.m_popupTreeNode != null && this.m_popupTreeNode.isRoot()) {
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeWSRRQuery() {
        Cursor currentCursor;
        DefaultMutableTreeNode selectedTreeNode;
        block24: {
            block23: {
                selectedTreeNode = null;
                if (this.m_lastWSRRRegistryObject == null) return;
                currentCursor = null;
                try {
                    try {
                        selectedTreeNode = this.getSelectedTreeNode();
                        if (selectedTreeNode == null) {
                            Object var13_3 = null;
                            if (this.m_treeModel != null && selectedTreeNode != null) {
                                this.m_treeModel.nodeStructureChanged(selectedTreeNode);
                            }
                            if (currentCursor == null) return;
                            break block23;
                        }
                        currentCursor = this.getCursor();
                        this.setCursor(Cursor.getPredefinedCursor(3));
                        String name = this.m_wsrrQueryNameUI.getText();
                        int queryNameLen = 0;
                        if (name != null) {
                            name = name.trim();
                            queryNameLen = name.length();
                        } else {
                            queryNameLen = 0;
                        }
                        boolean bCaseSensitive = this.m_wsrrQueryCaseSensitiveUI.isSelected();
                        WSWSRRWsdlDocument[] wsrrDocuments = null;
                        boolean bNeedFilter = true;
                        if (queryNameLen == 0) {
                            wsrrDocuments = this.m_lastWSRRRegistryObject.getAllWSDLDocuments();
                        } else {
                            try {
                                wsrrDocuments = this.m_lastWSRRRegistryObject.retrieveWSDLDocuments(name, bCaseSensitive);
                                bNeedFilter = false;
                            }
                            catch (Exception ex) {
                                wsrrDocuments = this.m_lastWSRRRegistryObject.getAllWSDLDocuments();
                            }
                        }
                        selectedTreeNode.removeAllChildren();
                        if (wsrrDocuments != null && wsrrDocuments.length > 0) {
                            Object[] docs = null;
                            if (bNeedFilter) {
                                docs = this.filterWSRRDocumentsByName(wsrrDocuments);
                            } else {
                                docs = new internalWSWSRRWsdlDocument[wsrrDocuments.length];
                                for (int i = 0; i < wsrrDocuments.length; ++i) {
                                    docs[i] = new internalWSWSRRWsdlDocument(wsrrDocuments[i]);
                                }
                            }
                            if (docs != null) {
                                VWQuickSort sort = new VWQuickSort(docs, 0);
                                sort.sort(0, docs.length - 1);
                                for (int i = 0; i < docs.length; ++i) {
                                    if (docs[i] == null) continue;
                                    DefaultMutableTreeNode wsrrDocumentNode = new DefaultMutableTreeNode(((internalWSWSRRWsdlDocument)docs[i]).getWSRRWsdlDocument());
                                    selectedTreeNode.add(wsrrDocumentNode);
                                }
                            }
                        }
                        TreePath[] treePath = this.m_tree.getSelectionPaths();
                        this.m_tree.scrollPathToVisible(treePath[0]);
                        if (treePath != null && treePath[0] != null && treePath[0].getLastPathComponent() == this.m_tree.getLastSelectedPathComponent()) {
                            this.m_tree.scrollPathToVisible(treePath[0]);
                        }
                        break block24;
                    }
                    catch (Exception ex) {
                        this.showMessage(VWResource.s_failedToQueryForWsrr.toString(selectedTreeNode), VWResource.s_refresh, 1, ex);
                        Object var13_5 = null;
                        if (this.m_treeModel != null && selectedTreeNode != null) {
                            this.m_treeModel.nodeStructureChanged(selectedTreeNode);
                        }
                        if (currentCursor == null) return;
                        this.setCursor(currentCursor);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var13_6 = null;
                    if (this.m_treeModel != null && selectedTreeNode != null) {
                        this.m_treeModel.nodeStructureChanged(selectedTreeNode);
                    }
                    if (currentCursor == null) throw throwable;
                    this.setCursor(currentCursor);
                    throw throwable;
                }
            }
            this.setCursor(currentCursor);
            return;
        }
        Object var13_4 = null;
        if (this.m_treeModel != null && selectedTreeNode != null) {
            this.m_treeModel.nodeStructureChanged(selectedTreeNode);
        }
        if (currentCursor == null) return;
        this.setCursor(currentCursor);
    }

    private internalWSWSRRWsdlDocument[] filterWSRRDocumentsByName(WSWSRRWsdlDocument[] wsrrDocuments) throws Exception {
        Vector<internalWSWSRRWsdlDocument> docs = new Vector<internalWSWSRRWsdlDocument>();
        if (this.m_wsrrQueryNameUI != null) {
            boolean bCaseSensitive = this.m_wsrrQueryCaseSensitiveUI.isSelected();
            String name = this.m_wsrrQueryNameUI.getText();
            int queryNameLen = -1;
            if (name != null) {
                queryNameLen = name.length();
            }
            if (wsrrDocuments != null && wsrrDocuments.length > 0) {
                for (int i = 0; i < wsrrDocuments.length; ++i) {
                    String wcName = wsrrDocuments[i].getName();
                    if (wcName == null || queryNameLen <= 0 || wcName.length() < queryNameLen) continue;
                    String s = null;
                    s = wcName;
                    if (bCaseSensitive ? VWStringUtils.compare(s, name) != 0 : VWStringUtils.compareIgnoreCase(s, name) != 0) continue;
                    docs.add(new internalWSWSRRWsdlDocument(wsrrDocuments[i]));
                }
            }
        }
        if (docs != null && docs.size() > 0) {
            internalWSWSRRWsdlDocument[] array = new internalWSWSRRWsdlDocument[docs.size()];
            docs.toArray(array);
            return array;
        }
        return null;
    }

    public synchronized void addItemListener(ItemListener listener) {
        this.m_selectListeners = AWTEventMulticaster.add(this.m_selectListeners, listener);
    }

    public synchronized void removeItemListener(ItemListener listener) {
        this.m_selectListeners = AWTEventMulticaster.remove(this.m_selectListeners, listener);
    }

    public void setBounds(int x, int y, int width, int height) {
        if (this.m_mainPanel != null) {
            int dividerLocation = this.m_mainPanel.getDividerLocation();
            super.setBounds(x, y, width, height);
            this.m_mainPanel.setDividerLocation(dividerLocation);
        } else {
            super.setBounds(x, y, width, height);
        }
    }

    public void setBounds(Rectangle r) {
        if (this.m_mainPanel != null) {
            int dividerLocation = this.m_mainPanel.getDividerLocation();
            super.setBounds(r);
            this.m_mainPanel.setDividerLocation(dividerLocation);
        } else {
            super.setBounds(r);
        }
    }

    public void insertUpdate(DocumentEvent event) {
        this.setButtonStatus(event);
    }

    public void removeUpdate(DocumentEvent event) {
        this.setButtonStatus(event);
    }

    public void changedUpdate(DocumentEvent event) {
    }

    private void setButtonStatus(DocumentEvent event) {
        Document doc = event.getDocument();
        JTextField textField = null;
        JButton button = null;
        if (this.m_wsrrQueryNameUI == null || doc != this.m_wsrrQueryNameUI.getDocument()) {
            return;
        }
        textField = this.m_wsrrQueryNameUI;
        button = this.m_wsrrQueryExecuteBtn;
        this.setButtonStatus(textField, button);
    }

    private void setButtonStatus(JTextField textField, JButton button) {
        String tempString;
        boolean bEnable = false;
        if (textField != null && (tempString = textField.getText()) != null) {
            tempString.trim();
            if (tempString.length() > 0) {
                bEnable = true;
            }
        }
        if (button.isEnabled() != bEnable) {
            button.setEnabled(bEnable);
        }
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    private Object getSelectedObject() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_tree.getLastSelectedPathComponent();
        if (node == null) {
            return null;
        }
        return node.getUserObject();
    }

    private DefaultMutableTreeNode getSelectedTreeNode() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_tree.getLastSelectedPathComponent();
        return node;
    }

    public Object[] getSelectedObjects() {
        Object nodeInfo = this.getSelectedObject();
        if (nodeInfo != null) {
            Object[] objects = null;
            objects = new Object[]{nodeInfo};
            return objects;
        }
        return null;
    }

    protected void notifySelectListeners() {
        Object nodeInfo = this.getSelectedObject();
        String wsdlURL = null;
        if (nodeInfo != null && !(nodeInfo instanceof WSWSRRRegistry[]) && !(nodeInfo instanceof WSWSRRRegistry) && nodeInfo instanceof WSWSRRWsdlDocument) {
            wsdlURL = ((WSWSRRWsdlDocument)nodeInfo).getP8WSRRDocumentURI();
        }
        ItemEvent event = new ItemEvent(this, 0, wsdlURL, 1);
        if (this.m_selectListeners != null) {
            this.m_selectListeners.itemStateChanged(event);
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        Object nodeInfo = this.getSelectedObject();
        JComponent newComponent = null;
        String accessibilityInfo = null;
        if (nodeInfo != null) {
            this.m_currentSelectedWsdlDocument = null;
            if (nodeInfo instanceof WSWSRRRegistry[]) {
                newComponent = this.m_blankPanel;
                accessibilityInfo = VWResource.s_wsrrRegistries;
            } else if (nodeInfo instanceof WSWSRRRegistry) {
                this.updateWSRRRegistryPanel((WSWSRRRegistry)nodeInfo);
                newComponent = this.m_wsrrRegistryPane;
                this.m_lastWSRRRegistryObject = (WSWSRRRegistry)nodeInfo;
                accessibilityInfo = ((WSWSRRRegistry)nodeInfo).getRegisteryHostName();
            } else if (nodeInfo instanceof WSWSRRWsdlDocument) {
                this.updateWSDLDocDetailsPanel((WSWSRRWsdlDocument)nodeInfo);
                this.updateCustomPropertiesPanel((WSWSRRWsdlDocument)nodeInfo);
                newComponent = this.m_tabbedPanel;
                this.m_currentSelectedWsdlDocument = this.m_lastSelectedWsdlDocument = (WSWSRRWsdlDocument)nodeInfo;
                accessibilityInfo = ((WSWSRRWsdlDocument)nodeInfo).getName();
            }
            this.notifySelectListeners();
            if (newComponent != null) {
                int dividerLocation = this.m_mainPanel.getDividerLocation();
                if (this.compOrientation.isLeftToRight()) {
                    this.m_mainPanel.setRightComponent(newComponent);
                } else {
                    this.m_mainPanel.setLeftComponent(newComponent);
                }
                this.m_mainPanel.setDividerLocation(dividerLocation);
                this.m_mainPanel.updateUI();
            }
            if (accessibilityInfo != null) {
                this.m_tree.getAccessibleContext().setAccessibleName(accessibilityInfo);
                this.m_tree.getAccessibleContext().setAccessibleDescription(accessibilityInfo);
            }
        }
    }

    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        TreePath treePath = event.getPath();
        Object obj = treePath.getLastPathComponent();
        if (obj != null && obj instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)obj;
        }
    }

    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
    }

    private String showMessage(String msg, String title, int msgType, Exception ex) {
        if (ex != null) {
            msg = msg == null ? new String(ex.toString()) : msg + "\n" + ex.toString();
        }
        if (this.m_parent instanceof Frame) {
            VWMessageDialog.showOptionDialog((Frame)this.m_parent, msg, title, msgType);
        } else if (this.m_parent instanceof JDialog) {
            VWMessageDialog.showOptionDialog((JDialog)this.m_parent, msg, title, msgType);
        } else {
            JOptionPane.showMessageDialog(this.m_parent, msg, title, msgType);
        }
        return msg;
    }

    class internalWSWSRRWsdlDocument
    implements IVWSortItem {
        WSWSRRWsdlDocument m_doc = null;

        internalWSWSRRWsdlDocument(WSWSRRWsdlDocument doc) {
            this.m_doc = doc;
        }

        public String getName() {
            if (this.m_doc != null) {
                return this.m_doc.getName();
            }
            return null;
        }

        public WSWSRRWsdlDocument getWSRRWsdlDocument() {
            return this.m_doc;
        }
    }

    class TreeCellRenderer
    extends DefaultTreeCellRenderer {
        private ImageIcon m_wsrrMainIcon = VWImageLoader.createImageIcon("wsrrMain.gif");
        private ImageIcon m_wsrrRegistryIcon = VWImageLoader.createImageIcon("wsrrRegistry.gif");
        private ImageIcon m_wsdlIcon = VWImageLoader.createImageIcon("wsrrWsdl.gif");

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component comp = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value != null) {
                String text = null;
                Object nodeInfo = null;
                if (value instanceof DefaultMutableTreeNode) {
                    nodeInfo = ((DefaultMutableTreeNode)value).getUserObject();
                }
                if (nodeInfo != null) {
                    if (nodeInfo instanceof VWWSRRRegistry[]) {
                        text = VWResource.s_wsrrRegistryAndRepository;
                        this.setIcon(this.m_wsrrMainIcon);
                    }
                    if (nodeInfo instanceof WSWSRRRegistry) {
                        text = ((WSWSRRRegistry)nodeInfo).toString();
                        this.setIcon(this.m_wsrrRegistryIcon);
                    } else if (nodeInfo instanceof WSWSRRWsdlDocument) {
                        String version = ((WSWSRRWsdlDocument)nodeInfo).getVersion();
                        text = version != null && version.trim().length() != 0 ? ((WSWSRRWsdlDocument)nodeInfo).toString() + " (" + version + ")" : ((WSWSRRWsdlDocument)nodeInfo).toString();
                        this.setIcon(this.m_wsdlIcon);
                    }
                } else {
                    text = VWResource.s_wsrrRegistryAndRepository;
                    this.setIcon(this.m_wsrrMainIcon);
                }
                this.setText(text);
                this.setToolTipText(text);
                return this;
            }
            return comp;
        }
    }
}

